/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.store.TransactionStoreActivity;
import cz.insophy.inplan.store.TransactionStoreActivityTarget;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.Localizer;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Date;

public abstract class StoreActivity
extends Activity {
    private StoreType storeType;
    private Material material;
    private double qty;
    private static final Comparator<StoreActivity> TIME_QTY_REV_COMPARATOR = (o1, o2) -> {
        int res = Comparators.compare(o1.getTime(), o2.getTime());
        if (res == 0) {
            res = Comparators.compare(o2.getQty(), o1.getQty());
        }
        return res;
    };

    public StoreActivity(StoreType type, long time, Material material, double qty) {
        if (material == null) {
            throw new IllegalArgumentException("Material in StoreActivity must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type in StoreActivity must not be null.");
        }
        this.storeType = type;
        this.material = material;
        this.setQty(qty);
        this.setTime(time);
    }

    protected StoreActivity(StoreActivity other) {
        this.storeType = other.storeType;
        this.material = other.material;
        this.qty = other.qty;
        this.setTime(other.start);
    }

    public long getTime() {
        if (this.getStart() == this.getEnd()) {
            return this.getStart();
        }
        throw new IllegalStateException("If using get/setTime then setStart/End should not be used separately.");
    }

    public void setTime(long time) {
        if (time != this.getTime()) {
            this.setStartEnd(time, time);
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public double getAbsQty() {
        return Math.abs(this.qty);
    }

    public void setQty(double qty) {
        if (qty == 0.0) {
            throw new IllegalArgumentException("Store activity quantity must not be 0");
        }
        this.qty = qty;
    }

    public StoreType getStoreType() {
        return this.storeType;
    }

    public void setType(StoreType type) {
        this.storeType = type;
    }

    public double getQty() {
        return this.qty;
    }

    public abstract Object getOriginator();

    @Override
    protected void preSetPlan() {
        Plan oldPlan = this.getPlan();
        if (oldPlan != null) {
            oldPlan.getStoreSchedule(this.getStoreType()).removeActivity(this);
        }
    }

    @Override
    protected void postSetPlan() {
        Plan plan = this.getPlan();
        if (plan != null) {
            plan.getStoreSchedule(this.getStoreType()).addActivity(this);
        }
    }

    public final String toString() {
        Comparable<Long> otime = Activity.convertDatesInToString ? new Date(this.getTime()) : Long.valueOf(this.getTime());
        return String.format("%s(time=%s, st=%s, mat=%s, q=%f%s)", new Object[]{this.getClass().getSimpleName(), otime, this.storeType, this.material, this.getQty(), this.toStringAdditional()});
    }

    protected String toStringAdditional() {
        return "";
    }

    public static Comparator<StoreActivity> timeQtyRevComparator() {
        return TIME_QTY_REV_COMPARATOR;
    }

    public static String getStoreActivityDetail(StoreActivity sa, NumberFormat numberFormat, boolean showTime, boolean showAmount) {
        StringBuilder sb = new StringBuilder(512);
        StoreActivity.appendStoreActivityDetail(sa, numberFormat, showTime, showAmount, sb);
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendStoreActivityDetail(StoreActivity sa, NumberFormat numberFormat, boolean showTime, boolean showAmount, StringBuilder sb) {
        if (sa.getQty() < 0.0) {
            sb.append(Localizer.getString("timepanel.store_item_renderer.allocation"));
        } else {
            sb.append(Localizer.getString("timepanel.store_item_renderer.lay_in"));
        }
        if (showTime) {
            sb.append(' ');
            sb.append(Formatter.formatShortDateTime(sa.getTime()));
        }
        if (showAmount) {
            sb.append("   ");
            sb.append(numberFormat.format(sa.getAbsQty()));
        } else {
            sb.append(":");
        }
        if (sa instanceof TransactionStoreActivity) {
            TransactionStoreActivity tsa = (TransactionStoreActivity)sa;
            TransactionStoreActivityTarget target = tsa.getTarget();
            sb.append(" ");
            if (!(target instanceof GeneralizedOrderRequest)) return;
            sb.append(Localizer.getString("timepanel.store_item_renderer.tx_gor", ((GeneralizedOrderRequest)target).getId()));
            return;
        } else if (sa instanceof InPlanStoreActivity) {
            StoreActivityOwner owner = ((InPlanStoreActivity)sa).getOwner();
            sb.append(" ");
            if (owner instanceof ActionActivity) {
                ActionActivity aa = (ActionActivity)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_aa", aa.getAction().getName(), ProductionTreeAlgorithms.getFarthestGor(aa).getId()));
                return;
            } else if (owner instanceof RebuildActivity) {
                RebuildActivity ra = (RebuildActivity)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_ra", ra.getToType().getName()));
                return;
            } else if (owner instanceof GeneralizedActionRequest) {
                GeneralizedActionRequest gar = (GeneralizedActionRequest)owner;
                if (sa.getQty() > 0.0) {
                    sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_gar_pos", gar.getAction().getName(), ProductionTreeAlgorithms.getFarthestGor(gar).getId()));
                    return;
                } else {
                    sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_gar", gar.getAction().getName(), ProductionTreeAlgorithms.getFarthestGor(gar).getId()));
                }
                return;
            } else if (owner instanceof GeneralizedOrderRequest) {
                GeneralizedOrderRequest gor = (GeneralizedOrderRequest)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_gor", gor.getId()));
                return;
            } else if (owner instanceof CustomerRequest) {
                CustomerRequest cr = (CustomerRequest)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_custreq", cr.getId()));
                return;
            } else {
                if (!(owner instanceof SupplyRequest)) throw new IllegalStateException("Unexpected store activity owner in " + sa);
                SupplyRequest sr = (SupplyRequest)owner;
                sb.append(Localizer.getString("timepanel.store_item_renderer.ipsa_supreq", sr.getId()));
            }
            return;
        } else {
            if (!(sa instanceof ExternalStoreActivity)) throw new IllegalStateException("Unknown kind of store activity " + sa);
            if (((ExternalStoreActivity)sa).getDescription() == null) return;
            sb.append(" ");
            sb.append(((ExternalStoreActivity)sa).getDescription());
        }
    }
}

